// Title      : Corpus.java
// Author     : James Baird
// Created    : Sunday, 4th November 2001
// Description: Corpus Class

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class Corpus
{
  public Corpus(String infilepath)
  {
    this.infilepath = infilepath;
    
    structures = new Vector();
    
    postVectors = new Hashtable();
    
    try
    {
      File directory = new File(infilepath);
    
      String[] infiles = directory.list();
      
      for (int i = 0; i < infiles.length; i++)
      {
        String infilename = infilepath + "/" + infiles[i];
      
        BufferedReader infile = new BufferedReader(new FileReader(infilename));
      
        String line = infile.readLine();
        while (line != null)
        {
          if (line.startsWith("*** POST"))
          {
            StringTokenizer tokeniser = new StringTokenizer(line);
          
            tokeniser.nextToken();
            tokeniser.nextToken();
            String group = tokeniser.nextToken();
            String id = tokeniser.nextToken();
            String structure = tokeniser.nextToken();
          
            if (!structure.equals("Q") && !structure.equals("UK"))
            {
              Post post = new Post(group, id, structure);
          
              if (!structures.contains(structure))
              {
                structures.addElement(structure);
            
                postVectors.put(structure, new Vector());
              }
            
              Vector posts = getPosts(structure);
          
              posts.addElement(post);
            }
          }
      
          line = infile.readLine();
        }
      
        infile.close();
      }
    }
    catch (IOException e)
    {
      e.printStackTrace();
    }
  }
  
  public Vector getStructures()
  {
    return structures;
  }
  
  public Vector getPosts(String structure)
  {
    return (Vector)postVectors.get(structure);
  }

  String infilepath;
  Vector structures;
  Hashtable postVectors;
}
